fig1 = figure('Color','w');
wave1 = [];
wave2 = [];
loss_wave1 = [];
loss_wave2 = [];
bend = [3,4,5,6,7];
bend6 = readmatrix('6cm.dat');
bend8 = readmatrix('8cm.dat');
bend10 = readmatrix('10cm.dat');
bend12 = readmatrix('12cm.dat');
bend14 = readmatrix('14cm.dat');
wavelength = bend6(:,1);

raw_data1 =  readmatrix('noise.dat');
noise = raw_data1(:,2);
wavelength2 = raw_data1(:,1);
p = polyfit(wavelength2,noise,1);
f = polyval(p,wavelength);

x0=10;
y0=10;
width=1800;
height=900;
% width=1500;
% height=550;

x = 12; % 235 nm
y = 30; % 345 nm
signal1 = (bend6(:,2) + bend6(:,4))/2;
signal2 = (bend6(:,6) + bend6(:,8))/2;
signal1 = signal1 - f;
signal2 = signal2 - f;
loss1 = (10*log10(signal1./signal2))/5;
trans1 = (signal2(x,:)./signal1(x,:));
wave1 = [wave1,trans1];
loss_wave1 = [loss_wave1,loss1(x,:)];
loss_wave2 = [loss_wave2,loss1(y,:)];

signal1 = (bend8(:,2) + bend8(:,4))/2;
signal2 = (bend8(:,6) + bend8(:,8))/2;
signal1 = signal1 - f;
signal2 = signal2 - f;
loss2 = (10*log10(signal1./signal2))/5;
trans1 = (signal2(x,:)./signal1(x,:));
wave1 = [wave1,trans1];
loss_wave1 = [loss_wave1,loss2(x,:)];
loss_wave2 = [loss_wave2,loss2(y,:)];

signal1 = (bend10(:,4) + bend10(:,6))/2;
signal2 = (bend10(:,2) + bend10(:,8))/2;
signal1 = signal1 - f;
signal2 = signal2 - f;
loss3 = (10*log10(signal1./signal2))/5;
trans1 = (signal2(x,:)./signal1(x,:));
wave1 = [wave1,trans1];
loss_wave1 = [loss_wave1,loss3(x,:)];
loss_wave2 = [loss_wave2,loss3(y,:)];

signal1 = (bend12(:,2) + bend12(:,4))/2;
signal2 = (bend12(:,6) + bend12(:,8))/2;
signal1 = signal1 - f;
signal2 = signal2 - f;
trans1 = (signal2(x,:)./signal1(x,:));
wave1 = [wave1,trans1];
loss4 = (10*log10(signal1./signal2))/5;
loss_wave1 = [loss_wave1,loss4(x,:)];
loss_wave2 = [loss_wave2,loss4(y,:)];

signal1 = (bend14(:,2) + bend14(:,4))/2;
signal2 = (bend14(:,6) + bend14(:,8))/2;
signal1 = signal1 - f;
signal2 = signal2 - f;
loss5 = (10*log10(signal1./signal2))/5;
trans1 = (signal2(x,:)./signal1(x,:));
wave1 = [wave1,trans1];
loss_wave1 = [loss_wave1,loss5(x,:)];
loss_wave2 = [loss_wave2,loss5(y,:)];

nexttile
hold on
box on
ax = gca;
ax.LineWidth = 2;
p1 = plot(wavelength,loss1,'LineWidth',3);
p2 = plot(wavelength,loss2,'LineWidth',3);
p3 = plot(wavelength,loss3,'LineWidth',3);
p4 = plot(wavelength,loss4,'LineWidth',3);
p5 = plot(wavelength,loss5,'LineWidth',3);
% title('Bend loss for different bend radii')
xlabel('Wavelength / nm')
ylabel('Bend loss (dB per turn)')
xlim([180 450])
ylim([0 2])
lgd = legend([p1 p2 p3 p4 p5],{' 3 cm ',' 4 cm ',' 5 cm ',' 6 cm ',' 7 cm ','box','on'});
lgd.FontSize = 38;
lgd.Box = 'off';
set(gca,'XMinorTick','on','YMinorTick','on')
set(gcf,'position',[x0,y0,width,height])
set(gca,'FontSize',34)

x = [245 265 265 245];
y = [0 0 2 2];
c = patch(x,y,'black','FaceAlpha',.3,'EdgeAlpha',.5);
set(get(get(c,'Annotation'),'LegendInformation'),...
    'IconDisplayStyle','off');

x2 = [180 195 195 180];
y2 = [0 0 2 2];
g = patch(x2,y2,'black','FaceAlpha',.3,'EdgeAlpha',.5);
set(get(get(g,'Annotation'),'LegendInformation'),...
    'IconDisplayStyle','off');

x2 = [410 450 450 410];
y2 = [0 0 2 2];
v = patch(x2,y2,'black','FaceAlpha',.3,'EdgeAlpha',.5);
set(get(get(v,'Annotation'),'LegendInformation'),...
    'IconDisplayStyle','off');
hold off



% nexttile
% hold on
% plot(bend,loss_wave1,'LineWidth',3)
% plot(bend,loss_wave2,'LineWidth',3)
% xlabel('Bend radius / cm')
% ylabel('Attenuation (dB per turn)')
% ylim([0 1])
% legend('Bend loss at 235nm','Bend loss at 325 nm')
% set(gca,'XMinorTick','on','YMinorTick','on')
% set(gca,'FontSize',20)
% hold off


